package com.example.sefinsa_app.ui.rmd.Ver;

import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.RecyclerView;

import com.example.sefinsa_app.R;
import com.example.sefinsa_app.controllers.RMDController;
import com.example.sefinsa_app.models.Articulo;
import com.example.sefinsa_app.ui.rmd.RMDFragment;
import com.example.sefinsa_app.utilities.NetworkChange;

import java.util.ArrayList;

public class DetalleRMDArticuloAdapter extends RecyclerView.Adapter<DetalleRMDArticuloAdapter.ViewHolder> {
    ArrayList<Articulo> articulos;
    private String rmdId;
    private RMDFragment fragment;
    private Context context;
    private FragmentActivity activity;

    public DetalleRMDArticuloAdapter(ArrayList<Articulo> articulos, String rmdId, RMDFragment fragment, Context context, FragmentActivity activity) {
        this.articulos = articulos;
        this.rmdId = rmdId;
        this.fragment = fragment;
        this.context = context;
        this.activity = activity;
    }

    public static class ViewHolder extends RecyclerView.ViewHolder {
        private TextView txtVwArticulo;
        private TextView txtVwMarca;
        private TextView txtVwColor;
        private Button btnDetalle;
        private Button btnFotos;

        public ViewHolder(@NonNull View view) {
            super(view);

            txtVwArticulo = view.findViewById(R.id.tvArticulo);
            txtVwMarca = view.findViewById(R.id.tvMarca);
            txtVwColor = view.findViewById(R.id.tvColor);
            btnDetalle = view.findViewById(R.id.btnDetalles);
            btnFotos = view.findViewById(R.id.btnFotos);
        }
    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.detalle_rmd_articulo_item, parent, false);
        return new ViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        Articulo articulo = articulos.get(position);

        holder.txtVwArticulo.setText("Artículo: " + articulo.getArticulo());
        holder.txtVwMarca.setText("Marca: " + articulo.getMarca());
        holder.txtVwColor.setText("Color: " + articulo.getColor());

        holder.btnDetalle.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                AlertDialog.Builder builder = new AlertDialog.Builder(context);
                builder.setTitle("Detalle condiciones");
                builder.setMessage(articulo.getDetalleCondiciones());
                builder.setPositiveButton("Cerrar", null);
                AlertDialog dialog = builder.create();
                dialog.show();
            }
        });

        holder.btnFotos.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (NetworkChange.isConnectedToInternet(context)) {
                    RMDController rmdController = new RMDController(context, activity);
                    rmdController.getRutasFotosFromServer(rmdId, articulo.getArticulo());
                } else {
                    AlertDialog.Builder builder = new AlertDialog.Builder(context);
                    builder.setTitle("Sin conexión a internet");
                    builder.setMessage("No es posible cargar las imagenes del artículo sin conexión a internet");
                    builder.setPositiveButton("Aceptar", null);
                    AlertDialog dialog = builder.create();
                    dialog.show();
                }
            }
        });
    }

    @Override
    public int getItemCount() { return articulos.size(); }
}
